<?php
require_once '../loader.php';
@session_start();
if (!isset($_SESSION['LOGADO']) || $_SESSION['LOGADO'] == FALSE) {
    @header('location:' . Validacao::getBase() . 'admin/logar/');
    exit;
}

$site = new Site();
$site->getMeta();
?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->
<!--[if !IE]><!--> <html lang="en"> <!--<![endif]-->

    <!-- START @HEAD -->
    <head>
        <!-- START @META SECTION -->
        <meta charset="utf-8">
        <?php require_once './base.php';?>
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <title><?= $site->site_meta_titulo ?></title>
        <!--/ END META SECTION -->

        <!-- START @FAVICONS -->
        <link href="./assets/img/ico/favicon.ico?<?= rand(0, 100) ?>" rel="shortcut icon" sizes="144x144">
        <!--/ END FAVICONS -->

        <!-- START @FONT STYLES -->
        <link href="//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700" rel="stylesheet">
        <!--/ END FONT STYLES -->

        <!-- START @GLOBAL MANDATORY STYLES -->
        <link href="./assets/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
        <!--/ END GLOBAL MANDATORY STYLES -->

        <!-- START @PAGE LEVEL STYLES -->
        <link href="./assets/fontawesome/css/font-awesome.min.css" rel="stylesheet">
        <link href="./assets/css/animate.min.css" rel="stylesheet">
        <!--/ END PAGE LEVEL STYLES -->

        <!-- START @THEME STYLES -->
        <link href="./assets/css/layout.css" rel="stylesheet">
        <link href="./assets/css/components.css" rel="stylesheet">
        <link href="./assets/css/plugins.css" rel="stylesheet">
        <link href="./assets/css/themes/default.theme.css" rel="stylesheet">
        <link href="./assets/css/custom.css" rel="stylesheet">
        <!--/ END THEME STYLES -->

        <!-- START @IE SUPPORT -->
        <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!--[if lt IE 9]>
        <script src="./assets/html5shiv/dist/html5shiv.min.js"></script>
        <script src="./assets/respond-minmax/dest/respond.min.js"></script>
        <![endif]-->
        <!--/ END IE SUPPORT -->
    </head>
    <!--/ END HEAD -->

    <body>

        <!--[if lt IE 9]>
        <p class="upgrade-browser">Upps!! You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/" target="_blank">upgrade your browser</a> to improve your experience.</p>
        <![endif]-->

        <!-- START @WRAPPER -->
        <section id="wrapper" class="page-sound">

            <!-- START @HEADER -->
            <div>
                <?php require_once './navegacao.php'; ?> <!-- /#header -->

            </div>
            <!--/ END HEADER -->

            <?php require_once './menu.php'; ?><!-- /#sidebar-left -->
            <!--/ END SIDEBAR LEFT -->

            <!-- START @PAGE CONTENT -->
            <section id="page-content">

                <!-- Start page header -->
                <div class="header-content">
                    <h2><i class="fa fa-paw"></i> Font Awesome <span>icones</span></h2>
                    <div class="breadcrumb-wrapper hidden-xs">
                        <span class="label">Você está em:</span>
                        <ol class="breadcrumb">
                            <li>
                                <i class="fa fa-home"></i>
                                <a href="home/">Dashboard</a>
                                <i class="fa fa-angle-right"></i>
                            </li>
                            
                            <li>
                                <a href="#">Icones</a>
                                <i class="fa fa-angle-right"></i>
                            </li>
                        </ol>
                    </div><!-- /.breadcrumb-wrapper -->
                </div><!-- /.header-content -->
                <!--/ End page header -->

                <!-- Start body content -->
                <div class="body-content animated fadeIn">

                    <div class="row">
                        <div class="col-md-12">

                            <!-- START FONT AWESOME -->
                            <div class="callout callout-info mb-20" style="padding-top:19px;">
                                <p><a href="http://fortawesome.github.io/Font-Awesome/" target="_blank">Font Awesome</a> fornece ícones que pode ser imediatamente personalizado - tamanho, cor, sombra projetada, e qualquer coisa que pode ser feito com o poder do CSS.</p>
                            </div>

                            <!-- Start new icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Font Awesome <span class="label label-danger">40 New Icons in 4.3</span></h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">
                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bed"><i class="fa fa-bed"></i> bed</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/buysellads"><i class="fa fa-buysellads"></i> buysellads</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cart-arrow-down"><i class="fa fa-cart-arrow-down"></i> cart-arrow-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cart-plus"><i class="fa fa-cart-plus"></i> cart-plus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/connectdevelop"><i class="fa fa-connectdevelop"></i> connectdevelop</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/dashcube"><i class="fa fa-dashcube"></i> dashcube</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/diamond"><i class="fa fa-diamond"></i> diamond</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/facebook-official"><i class="fa fa-facebook-official"></i> facebook-official</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/forumbee"><i class="fa fa-forumbee"></i> forumbee</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/heartbeat"><i class="fa fa-heartbeat"></i> heartbeat</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bed"><i class="fa fa-hotel"></i> hotel <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/leanpub"><i class="fa fa-leanpub"></i> leanpub</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars"><i class="fa fa-mars"></i> mars</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars-double"><i class="fa fa-mars-double"></i> mars-double</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars-stroke"><i class="fa fa-mars-stroke"></i> mars-stroke</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars-stroke-h"><i class="fa fa-mars-stroke-h"></i> mars-stroke-h</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars-stroke-v"><i class="fa fa-mars-stroke-v"></i> mars-stroke-v</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/medium"><i class="fa fa-medium"></i> medium</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mercury"><i class="fa fa-mercury"></i> mercury</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/motorcycle"><i class="fa fa-motorcycle"></i> motorcycle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/neuter"><i class="fa fa-neuter"></i> neuter</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pinterest-p"><i class="fa fa-pinterest-p"></i> pinterest-p</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sellsy"><i class="fa fa-sellsy"></i> sellsy</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/server"><i class="fa fa-server"></i> server</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ship"><i class="fa fa-ship"></i> ship</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/shirtsinbulk"><i class="fa fa-shirtsinbulk"></i> shirtsinbulk</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/simplybuilt"><i class="fa fa-simplybuilt"></i> simplybuilt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/skyatlas"><i class="fa fa-skyatlas"></i> skyatlas</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/street-view"><i class="fa fa-street-view"></i> street-view</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/subway"><i class="fa fa-subway"></i> subway</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/train"><i class="fa fa-train"></i> train</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/transgender"><i class="fa fa-transgender"></i> transgender</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/transgender-alt"><i class="fa fa-transgender-alt"></i> transgender-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/user-plus"><i class="fa fa-user-plus"></i> user-plus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/user-secret"><i class="fa fa-user-secret"></i> user-secret</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/user-times"><i class="fa fa-user-times"></i> user-times</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/venus"><i class="fa fa-venus"></i> venus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/venus-double"><i class="fa fa-venus-double"></i> venus-double</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/venus-mars"><i class="fa fa-venus-mars"></i> venus-mars</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/viacoin"><i class="fa fa-viacoin"></i> viacoin</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/whatsapp"><i class="fa fa-whatsapp"></i> whatsapp</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End new icons -->

                            <!-- Start web application icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Web Application Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/adjust"><i class="fa fa-adjust"></i> adjust</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/anchor"><i class="fa fa-anchor"></i> anchor</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/archive"><i class="fa fa-archive"></i> archive</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/area-chart"><i class="fa fa-area-chart"></i> area-chart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrows"><i class="fa fa-arrows"></i> arrows</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrows-h"><i class="fa fa-arrows-h"></i> arrows-h</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrows-v"><i class="fa fa-arrows-v"></i> arrows-v</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/asterisk"><i class="fa fa-asterisk"></i> asterisk</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/at"><i class="fa fa-at"></i> at</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/car"><i class="fa fa-automobile"></i> automobile <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ban"><i class="fa fa-ban"></i> ban</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/university"><i class="fa fa-bank"></i> bank <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bar-chart"><i class="fa fa-bar-chart"></i> bar-chart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bar-chart"><i class="fa fa-bar-chart-o"></i> bar-chart-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/barcode"><i class="fa fa-barcode"></i> barcode</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bars"><i class="fa fa-bars"></i> bars</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bed"><i class="fa fa-bed"></i> bed</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/beer"><i class="fa fa-beer"></i> beer</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bell"><i class="fa fa-bell"></i> bell</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bell-o"><i class="fa fa-bell-o"></i> bell-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bell-slash"><i class="fa fa-bell-slash"></i> bell-slash</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bell-slash-o"><i class="fa fa-bell-slash-o"></i> bell-slash-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bicycle"><i class="fa fa-bicycle"></i> bicycle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/binoculars"><i class="fa fa-binoculars"></i> binoculars</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/birthday-cake"><i class="fa fa-birthday-cake"></i> birthday-cake</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bolt"><i class="fa fa-bolt"></i> bolt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bomb"><i class="fa fa-bomb"></i> bomb</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/book"><i class="fa fa-book"></i> book</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bookmark"><i class="fa fa-bookmark"></i> bookmark</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bookmark-o"><i class="fa fa-bookmark-o"></i> bookmark-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/briefcase"><i class="fa fa-briefcase"></i> briefcase</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bug"><i class="fa fa-bug"></i> bug</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/building"><i class="fa fa-building"></i> building</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/building-o"><i class="fa fa-building-o"></i> building-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bullhorn"><i class="fa fa-bullhorn"></i> bullhorn</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bullseye"><i class="fa fa-bullseye"></i> bullseye</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bus"><i class="fa fa-bus"></i> bus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/taxi"><i class="fa fa-cab"></i> cab <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/calculator"><i class="fa fa-calculator"></i> calculator</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/calendar"><i class="fa fa-calendar"></i> calendar</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/calendar-o"><i class="fa fa-calendar-o"></i> calendar-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/camera"><i class="fa fa-camera"></i> camera</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/camera-retro"><i class="fa fa-camera-retro"></i> camera-retro</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/car"><i class="fa fa-car"></i> car</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-down"><i class="fa fa-caret-square-o-down"></i> caret-square-o-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-left"><i class="fa fa-caret-square-o-left"></i> caret-square-o-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-right"><i class="fa fa-caret-square-o-right"></i> caret-square-o-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-up"><i class="fa fa-caret-square-o-up"></i> caret-square-o-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cart-arrow-down"><i class="fa fa-cart-arrow-down"></i> cart-arrow-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cart-plus"><i class="fa fa-cart-plus"></i> cart-plus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cc"><i class="fa fa-cc"></i> cc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/certificate"><i class="fa fa-certificate"></i> certificate</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/check"><i class="fa fa-check"></i> check</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/check-circle"><i class="fa fa-check-circle"></i> check-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/check-circle-o"><i class="fa fa-check-circle-o"></i> check-circle-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/check-square"><i class="fa fa-check-square"></i> check-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/check-square-o"><i class="fa fa-check-square-o"></i> check-square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/child"><i class="fa fa-child"></i> child</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/circle"><i class="fa fa-circle"></i> circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/circle-o"><i class="fa fa-circle-o"></i> circle-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/circle-o-notch"><i class="fa fa-circle-o-notch"></i> circle-o-notch</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/circle-thin"><i class="fa fa-circle-thin"></i> circle-thin</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/clock-o"><i class="fa fa-clock-o"></i> clock-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/times"><i class="fa fa-close"></i> close <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cloud"><i class="fa fa-cloud"></i> cloud</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cloud-download"><i class="fa fa-cloud-download"></i> cloud-download</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cloud-upload"><i class="fa fa-cloud-upload"></i> cloud-upload</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/code"><i class="fa fa-code"></i> code</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/code-fork"><i class="fa fa-code-fork"></i> code-fork</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/coffee"><i class="fa fa-coffee"></i> coffee</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cog"><i class="fa fa-cog"></i> cog</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cogs"><i class="fa fa-cogs"></i> cogs</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/comment"><i class="fa fa-comment"></i> comment</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/comment-o"><i class="fa fa-comment-o"></i> comment-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/comments"><i class="fa fa-comments"></i> comments</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/comments-o"><i class="fa fa-comments-o"></i> comments-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/compass"><i class="fa fa-compass"></i> compass</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/copyright"><i class="fa fa-copyright"></i> copyright</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/credit-card"><i class="fa fa-credit-card"></i> credit-card</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/crop"><i class="fa fa-crop"></i> crop</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/crosshairs"><i class="fa fa-crosshairs"></i> crosshairs</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cube"><i class="fa fa-cube"></i> cube</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cubes"><i class="fa fa-cubes"></i> cubes</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cutlery"><i class="fa fa-cutlery"></i> cutlery</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tachometer"><i class="fa fa-dashboard"></i> dashboard <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/database"><i class="fa fa-database"></i> database</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/desktop"><i class="fa fa-desktop"></i> desktop</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/diamond"><i class="fa fa-diamond"></i> diamond</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/dot-circle-o"><i class="fa fa-dot-circle-o"></i> dot-circle-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/download"><i class="fa fa-download"></i> download</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pencil-square-o"><i class="fa fa-edit"></i> edit <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ellipsis-h"><i class="fa fa-ellipsis-h"></i> ellipsis-h</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ellipsis-v"><i class="fa fa-ellipsis-v"></i> ellipsis-v</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/envelope"><i class="fa fa-envelope"></i> envelope</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/envelope-o"><i class="fa fa-envelope-o"></i> envelope-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/envelope-square"><i class="fa fa-envelope-square"></i> envelope-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/eraser"><i class="fa fa-eraser"></i> eraser</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/exchange"><i class="fa fa-exchange"></i> exchange</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/exclamation"><i class="fa fa-exclamation"></i> exclamation</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/exclamation-circle"><i class="fa fa-exclamation-circle"></i> exclamation-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/exclamation-triangle"><i class="fa fa-exclamation-triangle"></i> exclamation-triangle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/external-link"><i class="fa fa-external-link"></i> external-link</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/external-link-square"><i class="fa fa-external-link-square"></i> external-link-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/eye"><i class="fa fa-eye"></i> eye</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/eye-slash"><i class="fa fa-eye-slash"></i> eye-slash</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/eyedropper"><i class="fa fa-eyedropper"></i> eyedropper</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/fax"><i class="fa fa-fax"></i> fax</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/female"><i class="fa fa-female"></i> female</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/fighter-jet"><i class="fa fa-fighter-jet"></i> fighter-jet</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-archive-o"><i class="fa fa-file-archive-o"></i> file-archive-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-audio-o"><i class="fa fa-file-audio-o"></i> file-audio-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-code-o"><i class="fa fa-file-code-o"></i> file-code-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-excel-o"><i class="fa fa-file-excel-o"></i> file-excel-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-image-o"><i class="fa fa-file-image-o"></i> file-image-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-video-o"><i class="fa fa-file-movie-o"></i> file-movie-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-pdf-o"><i class="fa fa-file-pdf-o"></i> file-pdf-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-image-o"><i class="fa fa-file-photo-o"></i> file-photo-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-image-o"><i class="fa fa-file-picture-o"></i> file-picture-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-powerpoint-o"><i class="fa fa-file-powerpoint-o"></i> file-powerpoint-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-audio-o"><i class="fa fa-file-sound-o"></i> file-sound-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-video-o"><i class="fa fa-file-video-o"></i> file-video-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-word-o"><i class="fa fa-file-word-o"></i> file-word-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-archive-o"><i class="fa fa-file-zip-o"></i> file-zip-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/film"><i class="fa fa-film"></i> film</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/filter"><i class="fa fa-filter"></i> filter</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/fire"><i class="fa fa-fire"></i> fire</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/fire-extinguisher"><i class="fa fa-fire-extinguisher"></i> fire-extinguisher</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/flag"><i class="fa fa-flag"></i> flag</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/flag-checkered"><i class="fa fa-flag-checkered"></i> flag-checkered</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/flag-o"><i class="fa fa-flag-o"></i> flag-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bolt"><i class="fa fa-flash"></i> flash <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/flask"><i class="fa fa-flask"></i> flask</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/folder"><i class="fa fa-folder"></i> folder</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/folder-o"><i class="fa fa-folder-o"></i> folder-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/folder-open"><i class="fa fa-folder-open"></i> folder-open</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/folder-open-o"><i class="fa fa-folder-open-o"></i> folder-open-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/frown-o"><i class="fa fa-frown-o"></i> frown-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/futbol-o"><i class="fa fa-futbol-o"></i> futbol-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/gamepad"><i class="fa fa-gamepad"></i> gamepad</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/gavel"><i class="fa fa-gavel"></i> gavel</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cog"><i class="fa fa-gear"></i> gear <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cogs"><i class="fa fa-gears"></i> gears <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/circle-thin"><i class="fa fa-genderless"></i> genderless <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/gift"><i class="fa fa-gift"></i> gift</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/glass"><i class="fa fa-glass"></i> glass</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/globe"><i class="fa fa-globe"></i> globe</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/graduation-cap"><i class="fa fa-graduation-cap"></i> graduation-cap</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/users"><i class="fa fa-group"></i> group <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/hdd-o"><i class="fa fa-hdd-o"></i> hdd-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/headphones"><i class="fa fa-headphones"></i> headphones</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/heart"><i class="fa fa-heart"></i> heart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/heart-o"><i class="fa fa-heart-o"></i> heart-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/heartbeat"><i class="fa fa-heartbeat"></i> heartbeat</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/history"><i class="fa fa-history"></i> history</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/home"><i class="fa fa-home"></i> home</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bed"><i class="fa fa-hotel"></i> hotel <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/picture-o"><i class="fa fa-image"></i> image <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/inbox"><i class="fa fa-inbox"></i> inbox</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/info"><i class="fa fa-info"></i> info</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/info-circle"><i class="fa fa-info-circle"></i> info-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/university"><i class="fa fa-institution"></i> institution <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/key"><i class="fa fa-key"></i> key</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/keyboard-o"><i class="fa fa-keyboard-o"></i> keyboard-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/language"><i class="fa fa-language"></i> language</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/laptop"><i class="fa fa-laptop"></i> laptop</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/leaf"><i class="fa fa-leaf"></i> leaf</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/gavel"><i class="fa fa-legal"></i> legal <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/lemon-o"><i class="fa fa-lemon-o"></i> lemon-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/level-down"><i class="fa fa-level-down"></i> level-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/level-up"><i class="fa fa-level-up"></i> level-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/life-ring"><i class="fa fa-life-bouy"></i> life-bouy <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/life-ring"><i class="fa fa-life-buoy"></i> life-buoy <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/life-ring"><i class="fa fa-life-ring"></i> life-ring</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/life-ring"><i class="fa fa-life-saver"></i> life-saver <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/lightbulb-o"><i class="fa fa-lightbulb-o"></i> lightbulb-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/line-chart"><i class="fa fa-line-chart"></i> line-chart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/location-arrow"><i class="fa fa-location-arrow"></i> location-arrow</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/lock"><i class="fa fa-lock"></i> lock</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/magic"><i class="fa fa-magic"></i> magic</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/magnet"><i class="fa fa-magnet"></i> magnet</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/share"><i class="fa fa-mail-forward"></i> mail-forward <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/reply"><i class="fa fa-mail-reply"></i> mail-reply <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/reply-all"><i class="fa fa-mail-reply-all"></i> mail-reply-all <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/male"><i class="fa fa-male"></i> male</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/map-marker"><i class="fa fa-map-marker"></i> map-marker</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/meh-o"><i class="fa fa-meh-o"></i> meh-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/microphone"><i class="fa fa-microphone"></i> microphone</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/microphone-slash"><i class="fa fa-microphone-slash"></i> microphone-slash</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/minus"><i class="fa fa-minus"></i> minus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/minus-circle"><i class="fa fa-minus-circle"></i> minus-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/minus-square"><i class="fa fa-minus-square"></i> minus-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/minus-square-o"><i class="fa fa-minus-square-o"></i> minus-square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mobile"><i class="fa fa-mobile"></i> mobile</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mobile"><i class="fa fa-mobile-phone"></i> mobile-phone <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/money"><i class="fa fa-money"></i> money</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/moon-o"><i class="fa fa-moon-o"></i> moon-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/graduation-cap"><i class="fa fa-mortar-board"></i> mortar-board <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/motorcycle"><i class="fa fa-motorcycle"></i> motorcycle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/music"><i class="fa fa-music"></i> music</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bars"><i class="fa fa-navicon"></i> navicon <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/newspaper-o"><i class="fa fa-newspaper-o"></i> newspaper-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paint-brush"><i class="fa fa-paint-brush"></i> paint-brush</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paper-plane"><i class="fa fa-paper-plane"></i> paper-plane</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paper-plane-o"><i class="fa fa-paper-plane-o"></i> paper-plane-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paw"><i class="fa fa-paw"></i> paw</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pencil"><i class="fa fa-pencil"></i> pencil</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pencil-square"><i class="fa fa-pencil-square"></i> pencil-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pencil-square-o"><i class="fa fa-pencil-square-o"></i> pencil-square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/phone"><i class="fa fa-phone"></i> phone</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/phone-square"><i class="fa fa-phone-square"></i> phone-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/picture-o"><i class="fa fa-photo"></i> photo <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/picture-o"><i class="fa fa-picture-o"></i> picture-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pie-chart"><i class="fa fa-pie-chart"></i> pie-chart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/plane"><i class="fa fa-plane"></i> plane</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/plug"><i class="fa fa-plug"></i> plug</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/plus"><i class="fa fa-plus"></i> plus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/plus-circle"><i class="fa fa-plus-circle"></i> plus-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/plus-square"><i class="fa fa-plus-square"></i> plus-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/plus-square-o"><i class="fa fa-plus-square-o"></i> plus-square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/power-off"><i class="fa fa-power-off"></i> power-off</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/print"><i class="fa fa-print"></i> print</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/puzzle-piece"><i class="fa fa-puzzle-piece"></i> puzzle-piece</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/qrcode"><i class="fa fa-qrcode"></i> qrcode</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/question"><i class="fa fa-question"></i> question</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/question-circle"><i class="fa fa-question-circle"></i> question-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/quote-left"><i class="fa fa-quote-left"></i> quote-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/quote-right"><i class="fa fa-quote-right"></i> quote-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/random"><i class="fa fa-random"></i> random</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/recycle"><i class="fa fa-recycle"></i> recycle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/refresh"><i class="fa fa-refresh"></i> refresh</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/times"><i class="fa fa-remove"></i> remove <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bars"><i class="fa fa-reorder"></i> reorder <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/reply"><i class="fa fa-reply"></i> reply</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/reply-all"><i class="fa fa-reply-all"></i> reply-all</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/retweet"><i class="fa fa-retweet"></i> retweet</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/road"><i class="fa fa-road"></i> road</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/rocket"><i class="fa fa-rocket"></i> rocket</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/rss"><i class="fa fa-rss"></i> rss</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/rss-square"><i class="fa fa-rss-square"></i> rss-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/search"><i class="fa fa-search"></i> search</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/search-minus"><i class="fa fa-search-minus"></i> search-minus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/search-plus"><i class="fa fa-search-plus"></i> search-plus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paper-plane"><i class="fa fa-send"></i> send <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paper-plane-o"><i class="fa fa-send-o"></i> send-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/server"><i class="fa fa-server"></i> server</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/share"><i class="fa fa-share"></i> share</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/share-alt"><i class="fa fa-share-alt"></i> share-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/share-alt-square"><i class="fa fa-share-alt-square"></i> share-alt-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/share-square"><i class="fa fa-share-square"></i> share-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/share-square-o"><i class="fa fa-share-square-o"></i> share-square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/shield"><i class="fa fa-shield"></i> shield</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ship"><i class="fa fa-ship"></i> ship</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/shopping-cart"><i class="fa fa-shopping-cart"></i> shopping-cart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sign-in"><i class="fa fa-sign-in"></i> sign-in</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sign-out"><i class="fa fa-sign-out"></i> sign-out</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/signal"><i class="fa fa-signal"></i> signal</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sitemap"><i class="fa fa-sitemap"></i> sitemap</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sliders"><i class="fa fa-sliders"></i> sliders</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/smile-o"><i class="fa fa-smile-o"></i> smile-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/futbol-o"><i class="fa fa-soccer-ball-o"></i> soccer-ball-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort"><i class="fa fa-sort"></i> sort</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-alpha-asc"><i class="fa fa-sort-alpha-asc"></i> sort-alpha-asc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-alpha-desc"><i class="fa fa-sort-alpha-desc"></i> sort-alpha-desc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-amount-asc"><i class="fa fa-sort-amount-asc"></i> sort-amount-asc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-amount-desc"><i class="fa fa-sort-amount-desc"></i> sort-amount-desc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-asc"><i class="fa fa-sort-asc"></i> sort-asc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-desc"><i class="fa fa-sort-desc"></i> sort-desc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-desc"><i class="fa fa-sort-down"></i> sort-down <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-numeric-asc"><i class="fa fa-sort-numeric-asc"></i> sort-numeric-asc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-numeric-desc"><i class="fa fa-sort-numeric-desc"></i> sort-numeric-desc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort-asc"><i class="fa fa-sort-up"></i> sort-up <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/space-shuttle"><i class="fa fa-space-shuttle"></i> space-shuttle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/spinner"><i class="fa fa-spinner"></i> spinner</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/spoon"><i class="fa fa-spoon"></i> spoon</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/square"><i class="fa fa-square"></i> square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/square-o"><i class="fa fa-square-o"></i> square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/star"><i class="fa fa-star"></i> star</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/star-half"><i class="fa fa-star-half"></i> star-half</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/star-half-o"><i class="fa fa-star-half-empty"></i> star-half-empty <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/star-half-o"><i class="fa fa-star-half-full"></i> star-half-full <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/star-half-o"><i class="fa fa-star-half-o"></i> star-half-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/star-o"><i class="fa fa-star-o"></i> star-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/street-view"><i class="fa fa-street-view"></i> street-view</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/suitcase"><i class="fa fa-suitcase"></i> suitcase</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sun-o"><i class="fa fa-sun-o"></i> sun-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/life-ring"><i class="fa fa-support"></i> support <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tablet"><i class="fa fa-tablet"></i> tablet</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tachometer"><i class="fa fa-tachometer"></i> tachometer</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tag"><i class="fa fa-tag"></i> tag</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tags"><i class="fa fa-tags"></i> tags</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tasks"><i class="fa fa-tasks"></i> tasks</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/taxi"><i class="fa fa-taxi"></i> taxi</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/terminal"><i class="fa fa-terminal"></i> terminal</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/thumb-tack"><i class="fa fa-thumb-tack"></i> thumb-tack</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/thumbs-down"><i class="fa fa-thumbs-down"></i> thumbs-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/thumbs-o-down"><i class="fa fa-thumbs-o-down"></i> thumbs-o-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/thumbs-o-up"><i class="fa fa-thumbs-o-up"></i> thumbs-o-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/thumbs-up"><i class="fa fa-thumbs-up"></i> thumbs-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ticket"><i class="fa fa-ticket"></i> ticket</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/times"><i class="fa fa-times"></i> times</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/times-circle"><i class="fa fa-times-circle"></i> times-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/times-circle-o"><i class="fa fa-times-circle-o"></i> times-circle-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tint"><i class="fa fa-tint"></i> tint</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-down"><i class="fa fa-toggle-down"></i> toggle-down <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-left"><i class="fa fa-toggle-left"></i> toggle-left <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/toggle-off"><i class="fa fa-toggle-off"></i> toggle-off</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/toggle-on"><i class="fa fa-toggle-on"></i> toggle-on</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-right"><i class="fa fa-toggle-right"></i> toggle-right <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-up"><i class="fa fa-toggle-up"></i> toggle-up <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/trash"><i class="fa fa-trash"></i> trash</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/trash-o"><i class="fa fa-trash-o"></i> trash-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tree"><i class="fa fa-tree"></i> tree</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/trophy"><i class="fa fa-trophy"></i> trophy</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/truck"><i class="fa fa-truck"></i> truck</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tty"><i class="fa fa-tty"></i> tty</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/umbrella"><i class="fa fa-umbrella"></i> umbrella</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/university"><i class="fa fa-university"></i> university</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/unlock"><i class="fa fa-unlock"></i> unlock</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/unlock-alt"><i class="fa fa-unlock-alt"></i> unlock-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sort"><i class="fa fa-unsorted"></i> unsorted <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/upload"><i class="fa fa-upload"></i> upload</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/user"><i class="fa fa-user"></i> user</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/user-plus"><i class="fa fa-user-plus"></i> user-plus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/user-secret"><i class="fa fa-user-secret"></i> user-secret</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/user-times"><i class="fa fa-user-times"></i> user-times</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/users"><i class="fa fa-users"></i> users</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/video-camera"><i class="fa fa-video-camera"></i> video-camera</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/volume-down"><i class="fa fa-volume-down"></i> volume-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/volume-off"><i class="fa fa-volume-off"></i> volume-off</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/volume-up"><i class="fa fa-volume-up"></i> volume-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/exclamation-triangle"><i class="fa fa-warning"></i> warning <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/wheelchair"><i class="fa fa-wheelchair"></i> wheelchair</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/wifi"><i class="fa fa-wifi"></i> wifi</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/wrench"><i class="fa fa-wrench"></i> wrench</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End web application icons -->

                            <!-- Start transportation icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Transportation Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ambulance"><i class="fa fa-ambulance"></i> ambulance</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/car"><i class="fa fa-automobile"></i> automobile <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bicycle"><i class="fa fa-bicycle"></i> bicycle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bus"><i class="fa fa-bus"></i> bus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/taxi"><i class="fa fa-cab"></i> cab <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/car"><i class="fa fa-car"></i> car</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/fighter-jet"><i class="fa fa-fighter-jet"></i> fighter-jet</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/motorcycle"><i class="fa fa-motorcycle"></i> motorcycle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/plane"><i class="fa fa-plane"></i> plane</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/rocket"><i class="fa fa-rocket"></i> rocket</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ship"><i class="fa fa-ship"></i> ship</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/space-shuttle"><i class="fa fa-space-shuttle"></i> space-shuttle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/subway"><i class="fa fa-subway"></i> subway</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/taxi"><i class="fa fa-taxi"></i> taxi</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/train"><i class="fa fa-train"></i> train</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/truck"><i class="fa fa-truck"></i> truck</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/wheelchair"><i class="fa fa-wheelchair"></i> wheelchair</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End transportation icons -->

                            <!-- Start gender icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Gender Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/circle-thin"><i class="fa fa-circle-thin"></i> circle-thin</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/circle-thin"><i class="fa fa-genderless"></i> genderless <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars"><i class="fa fa-mars"></i> mars</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars-double"><i class="fa fa-mars-double"></i> mars-double</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars-stroke"><i class="fa fa-mars-stroke"></i> mars-stroke</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars-stroke-h"><i class="fa fa-mars-stroke-h"></i> mars-stroke-h</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mars-stroke-v"><i class="fa fa-mars-stroke-v"></i> mars-stroke-v</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/mercury"><i class="fa fa-mercury"></i> mercury</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/neuter"><i class="fa fa-neuter"></i> neuter</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/transgender"><i class="fa fa-transgender"></i> transgender</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/transgender-alt"><i class="fa fa-transgender-alt"></i> transgender-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/venus"><i class="fa fa-venus"></i> venus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/venus-double"><i class="fa fa-venus-double"></i> venus-double</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/venus-mars"><i class="fa fa-venus-mars"></i> venus-mars</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End gender icons -->

                            <!-- Start file type icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">File Type Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file"><i class="fa fa-file"></i> file</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-archive-o"><i class="fa fa-file-archive-o"></i> file-archive-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-audio-o"><i class="fa fa-file-audio-o"></i> file-audio-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-code-o"><i class="fa fa-file-code-o"></i> file-code-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-excel-o"><i class="fa fa-file-excel-o"></i> file-excel-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-image-o"><i class="fa fa-file-image-o"></i> file-image-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-video-o"><i class="fa fa-file-movie-o"></i> file-movie-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-o"><i class="fa fa-file-o"></i> file-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-pdf-o"><i class="fa fa-file-pdf-o"></i> file-pdf-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-image-o"><i class="fa fa-file-photo-o"></i> file-photo-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-image-o"><i class="fa fa-file-picture-o"></i> file-picture-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-powerpoint-o"><i class="fa fa-file-powerpoint-o"></i> file-powerpoint-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-audio-o"><i class="fa fa-file-sound-o"></i> file-sound-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-text"><i class="fa fa-file-text"></i> file-text</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-text-o"><i class="fa fa-file-text-o"></i> file-text-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-video-o"><i class="fa fa-file-video-o"></i> file-video-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-word-o"><i class="fa fa-file-word-o"></i> file-word-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-archive-o"><i class="fa fa-file-zip-o"></i> file-zip-o <span class="text-muted">(alias)</span></a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End file type icons -->

                            <!-- Start spinner icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Spinner Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/circle-o-notch"><i class="fa fa-circle-o-notch fa-spin"></i> fa-circle-o-notch</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/cog"><i class="fa fa-cog fa-spin"></i> fa-cog</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/cog"><i class="fa fa-gear fa-spin"></i> fa-gear <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/refresh"><i class="fa fa-refresh fa-spin"></i> fa-refresh</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/spinner"><i class="fa fa-spinner fa-spin"></i> fa-spinner</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End spinner icons -->

                            <!-- Start form control icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Form Control Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/check-square"><i class="fa fa-check-square"></i> fa-check-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/check-square-o"><i class="fa fa-check-square-o"></i> fa-check-square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/circle"><i class="fa fa-circle"></i> fa-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/circle-o"><i class="fa fa-circle-o"></i> fa-circle-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/dot-circle-o"><i class="fa fa-dot-circle-o"></i> fa-dot-circle-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/minus-square"><i class="fa fa-minus-square"></i> fa-minus-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/minus-square-o"><i class="fa fa-minus-square-o"></i> fa-minus-square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/plus-square"><i class="fa fa-plus-square"></i> fa-plus-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/plus-square-o"><i class="fa fa-plus-square-o"></i> fa-plus-square-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/square"><i class="fa fa-square"></i> fa-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/square-o"><i class="fa fa-square-o"></i> fa-square-o</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End form control icons -->

                            <!-- Start payment icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Payment Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/cc-amex"><i class="fa fa-cc-amex"></i> fa-cc-amex</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/cc-discover"><i class="fa fa-cc-discover"></i> fa-cc-discover</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/cc-mastercard"><i class="fa fa-cc-mastercard"></i> fa-cc-mastercard</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/cc-paypal"><i class="fa fa-cc-paypal"></i> fa-cc-paypal</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/cc-stripe"><i class="fa fa-cc-stripe"></i> fa-cc-stripe</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/cc-visa"><i class="fa fa-cc-visa"></i> fa-cc-visa</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/credit-card"><i class="fa fa-credit-card"></i> fa-credit-card</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/google-wallet"><i class="fa fa-google-wallet"></i> fa-google-wallet</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/paypal"><i class="fa fa-paypal"></i> fa-paypal</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End payment icons -->

                            <!-- Start chart icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Chart Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/area-chart"><i class="fa fa-area-chart"></i> fa-area-chart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/bar-chart"><i class="fa fa-bar-chart"></i> fa-bar-chart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/bar-chart"><i class="fa fa-bar-chart-o"></i> fa-bar-chart-o <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/line-chart"><i class="fa fa-line-chart"></i> fa-line-chart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/pie-chart"><i class="fa fa-pie-chart"></i> fa-pie-chart</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End chart icons -->

                            <!-- Start currency icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Currency Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/btc"><i class="fa fa-bitcoin"></i> fa-bitcoin <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/btc"><i class="fa fa-btc"></i> fa-btc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/jpy"><i class="fa fa-cny"></i> fa-cny <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/usd"><i class="fa fa-dollar"></i> fa-dollar <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/eur"><i class="fa fa-eur"></i> fa-eur</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/eur"><i class="fa fa-euro"></i> fa-euro <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/gbp"><i class="fa fa-gbp"></i> fa-gbp</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/ils"><i class="fa fa-ils"></i> fa-ils</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/inr"><i class="fa fa-inr"></i> fa-inr</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/jpy"><i class="fa fa-jpy"></i> fa-jpy</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/krw"><i class="fa fa-krw"></i> fa-krw</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/money"><i class="fa fa-money"></i> fa-money</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/jpy"><i class="fa fa-rmb"></i> fa-rmb <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/rub"><i class="fa fa-rouble"></i> fa-rouble <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/rub"><i class="fa fa-rub"></i> fa-rub</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/rub"><i class="fa fa-ruble"></i> fa-ruble <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/inr"><i class="fa fa-rupee"></i> fa-rupee <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/ils"><i class="fa fa-shekel"></i> fa-shekel <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/ils"><i class="fa fa-sheqel"></i> fa-sheqel <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/try"><i class="fa fa-try"></i> fa-try</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/try"><i class="fa fa-turkish-lira"></i> fa-turkish-lira <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/usd"><i class="fa fa-usd"></i> fa-usd</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/krw"><i class="fa fa-won"></i> fa-won <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/jpy"><i class="fa fa-yen"></i> fa-yen <span class="text-muted">(alias)</span></a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End currency icons -->

                            <!-- Start text editor icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Text Editor Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/align-center"><i class="fa fa-align-center"></i> align-center</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/align-justify"><i class="fa fa-align-justify"></i> align-justify</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/align-left"><i class="fa fa-align-left"></i> align-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/align-right"><i class="fa fa-align-right"></i> align-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bold"><i class="fa fa-bold"></i> bold</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/link"><i class="fa fa-chain"></i> chain <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chain-broken"><i class="fa fa-chain-broken"></i> chain-broken</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/clipboard"><i class="fa fa-clipboard"></i> clipboard</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/columns"><i class="fa fa-columns"></i> columns</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/files-o"><i class="fa fa-copy"></i> copy <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/scissors"><i class="fa fa-cut"></i> cut <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/outdent"><i class="fa fa-dedent"></i> dedent <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/eraser"><i class="fa fa-eraser"></i> eraser</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file"><i class="fa fa-file"></i> file</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-o"><i class="fa fa-file-o"></i> file-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-text"><i class="fa fa-file-text"></i> file-text</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/file-text-o"><i class="fa fa-file-text-o"></i> file-text-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/files-o"><i class="fa fa-files-o"></i> files-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/floppy-o"><i class="fa fa-floppy-o"></i> floppy-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/font"><i class="fa fa-font"></i> font</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/header"><i class="fa fa-header"></i> header</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/indent"><i class="fa fa-indent"></i> indent</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/italic"><i class="fa fa-italic"></i> italic</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/link"><i class="fa fa-link"></i> link</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/list"><i class="fa fa-list"></i> list</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/list-alt"><i class="fa fa-list-alt"></i> list-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/list-ol"><i class="fa fa-list-ol"></i> list-ol</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/list-ul"><i class="fa fa-list-ul"></i> list-ul</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/outdent"><i class="fa fa-outdent"></i> outdent</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paperclip"><i class="fa fa-paperclip"></i> paperclip</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paragraph"><i class="fa fa-paragraph"></i> paragraph</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/clipboard"><i class="fa fa-paste"></i> paste <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/repeat"><i class="fa fa-repeat"></i> repeat</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/undo"><i class="fa fa-rotate-left"></i> rotate-left <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/repeat"><i class="fa fa-rotate-right"></i> rotate-right <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/floppy-o"><i class="fa fa-save"></i> save <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/scissors"><i class="fa fa-scissors"></i> scissors</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/strikethrough"><i class="fa fa-strikethrough"></i> strikethrough</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/subscript"><i class="fa fa-subscript"></i> subscript</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/superscript"><i class="fa fa-superscript"></i> superscript</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/table"><i class="fa fa-table"></i> table</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/text-height"><i class="fa fa-text-height"></i> text-height</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/text-width"><i class="fa fa-text-width"></i> text-width</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/th"><i class="fa fa-th"></i> th</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/th-large"><i class="fa fa-th-large"></i> th-large</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/th-list"><i class="fa fa-th-list"></i> th-list</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/underline"><i class="fa fa-underline"></i> underline</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/undo"><i class="fa fa-undo"></i> undo</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chain-broken"><i class="fa fa-unlink"></i> unlink <span class="text-muted">(alias)</span></a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End text editor icons -->

                            <!-- Start directional icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Directional Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angle-double-down"><i class="fa fa-angle-double-down"></i> angle-double-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angle-double-left"><i class="fa fa-angle-double-left"></i> angle-double-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angle-double-right"><i class="fa fa-angle-double-right"></i> angle-double-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angle-double-up"><i class="fa fa-angle-double-up"></i> angle-double-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angle-down"><i class="fa fa-angle-down"></i> angle-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angle-left"><i class="fa fa-angle-left"></i> angle-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angle-right"><i class="fa fa-angle-right"></i> angle-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angle-up"><i class="fa fa-angle-up"></i> angle-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-circle-down"><i class="fa fa-arrow-circle-down"></i> arrow-circle-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-circle-left"><i class="fa fa-arrow-circle-left"></i> arrow-circle-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-circle-o-down"><i class="fa fa-arrow-circle-o-down"></i> arrow-circle-o-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-circle-o-left"><i class="fa fa-arrow-circle-o-left"></i> arrow-circle-o-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-circle-o-right"><i class="fa fa-arrow-circle-o-right"></i> arrow-circle-o-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-circle-o-up"><i class="fa fa-arrow-circle-o-up"></i> arrow-circle-o-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-circle-right"><i class="fa fa-arrow-circle-right"></i> arrow-circle-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-circle-up"><i class="fa fa-arrow-circle-up"></i> arrow-circle-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-down"><i class="fa fa-arrow-down"></i> arrow-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-left"><i class="fa fa-arrow-left"></i> arrow-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-right"><i class="fa fa-arrow-right"></i> arrow-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrow-up"><i class="fa fa-arrow-up"></i> arrow-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrows"><i class="fa fa-arrows"></i> arrows</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrows-alt"><i class="fa fa-arrows-alt"></i> arrows-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrows-h"><i class="fa fa-arrows-h"></i> arrows-h</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/arrows-v"><i class="fa fa-arrows-v"></i> arrows-v</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-down"><i class="fa fa-caret-down"></i> caret-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-left"><i class="fa fa-caret-left"></i> caret-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-right"><i class="fa fa-caret-right"></i> caret-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-down"><i class="fa fa-caret-square-o-down"></i> caret-square-o-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-left"><i class="fa fa-caret-square-o-left"></i> caret-square-o-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-right"><i class="fa fa-caret-square-o-right"></i> caret-square-o-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-up"><i class="fa fa-caret-square-o-up"></i> caret-square-o-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-up"><i class="fa fa-caret-up"></i> caret-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chevron-circle-down"><i class="fa fa-chevron-circle-down"></i> chevron-circle-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chevron-circle-left"><i class="fa fa-chevron-circle-left"></i> chevron-circle-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chevron-circle-right"><i class="fa fa-chevron-circle-right"></i> chevron-circle-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chevron-circle-up"><i class="fa fa-chevron-circle-up"></i> chevron-circle-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chevron-down"><i class="fa fa-chevron-down"></i> chevron-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chevron-left"><i class="fa fa-chevron-left"></i> chevron-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chevron-right"><i class="fa fa-chevron-right"></i> chevron-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/chevron-up"><i class="fa fa-chevron-up"></i> chevron-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/hand-o-down"><i class="fa fa-hand-o-down"></i> hand-o-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/hand-o-left"><i class="fa fa-hand-o-left"></i> hand-o-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/hand-o-right"><i class="fa fa-hand-o-right"></i> hand-o-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/hand-o-up"><i class="fa fa-hand-o-up"></i> hand-o-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/long-arrow-down"><i class="fa fa-long-arrow-down"></i> long-arrow-down</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/long-arrow-left"><i class="fa fa-long-arrow-left"></i> long-arrow-left</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/long-arrow-right"><i class="fa fa-long-arrow-right"></i> long-arrow-right</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/long-arrow-up"><i class="fa fa-long-arrow-up"></i> long-arrow-up</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-down"><i class="fa fa-toggle-down"></i> toggle-down <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-left"><i class="fa fa-toggle-left"></i> toggle-left <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-right"><i class="fa fa-toggle-right"></i> toggle-right <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/caret-square-o-up"><i class="fa fa-toggle-up"></i> toggle-up <span class="text-muted">(alias)</span></a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End directional icons -->

                            <!-- Start video player icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Video Player Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/arrows-alt"><i class="fa fa-arrows-alt"></i> fa-arrows-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/backward"><i class="fa fa-backward"></i> fa-backward</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/compress"><i class="fa fa-compress"></i> fa-compress</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/eject"><i class="fa fa-eject"></i> fa-eject</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/expand"><i class="fa fa-expand"></i> fa-expand</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/fast-backward"><i class="fa fa-fast-backward"></i> fa-fast-backward</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/fast-forward"><i class="fa fa-fast-forward"></i> fa-fast-forward</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/forward"><i class="fa fa-forward"></i> fa-forward</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/pause"><i class="fa fa-pause"></i> fa-pause</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/play"><i class="fa fa-play"></i> fa-play</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/play-circle"><i class="fa fa-play-circle"></i> fa-play-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/play-circle-o"><i class="fa fa-play-circle-o"></i> fa-play-circle-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/step-backward"><i class="fa fa-step-backward"></i> fa-step-backward</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/step-forward"><i class="fa fa-step-forward"></i> fa-step-forward</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/stop"><i class="fa fa-stop"></i> fa-stop</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a target="_blank" href="http://fontawesome.io/icon/youtube-play"><i class="fa fa-youtube-play"></i> fa-youtube-play</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End video player icons -->

                            <!-- Start brand icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Brand Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/adn"><i class="fa fa-adn"></i> adn</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/android"><i class="fa fa-android"></i> android</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/angellist"><i class="fa fa-angellist"></i> angellist</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/apple"><i class="fa fa-apple"></i> apple</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/behance"><i class="fa fa-behance"></i> behance</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/behance-square"><i class="fa fa-behance-square"></i> behance-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bitbucket"><i class="fa fa-bitbucket"></i> bitbucket</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/bitbucket-square"><i class="fa fa-bitbucket-square"></i> bitbucket-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/btc"><i class="fa fa-bitcoin"></i> bitcoin <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/btc"><i class="fa fa-btc"></i> btc</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/buysellads"><i class="fa fa-buysellads"></i> buysellads</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cc-amex"><i class="fa fa-cc-amex"></i> cc-amex</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cc-discover"><i class="fa fa-cc-discover"></i> cc-discover</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cc-mastercard"><i class="fa fa-cc-mastercard"></i> cc-mastercard</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cc-paypal"><i class="fa fa-cc-paypal"></i> cc-paypal</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cc-stripe"><i class="fa fa-cc-stripe"></i> cc-stripe</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/cc-visa"><i class="fa fa-cc-visa"></i> cc-visa</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/codepen"><i class="fa fa-codepen"></i> codepen</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/connectdevelop"><i class="fa fa-connectdevelop"></i> connectdevelop</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/css3"><i class="fa fa-css3"></i> css3</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/dashcube"><i class="fa fa-dashcube"></i> dashcube</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/delicious"><i class="fa fa-delicious"></i> delicious</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/deviantart"><i class="fa fa-deviantart"></i> deviantart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/digg"><i class="fa fa-digg"></i> digg</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/dribbble"><i class="fa fa-dribbble"></i> dribbble</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/dropbox"><i class="fa fa-dropbox"></i> dropbox</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/drupal"><i class="fa fa-drupal"></i> drupal</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/empire"><i class="fa fa-empire"></i> empire</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/facebook"><i class="fa fa-facebook"></i> facebook</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/facebook"><i class="fa fa-facebook-f"></i> facebook-f <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/facebook-official"><i class="fa fa-facebook-official"></i> facebook-official</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/facebook-square"><i class="fa fa-facebook-square"></i> facebook-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/flickr"><i class="fa fa-flickr"></i> flickr</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/forumbee"><i class="fa fa-forumbee"></i> forumbee</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/foursquare"><i class="fa fa-foursquare"></i> foursquare</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/empire"><i class="fa fa-ge"></i> ge <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/git"><i class="fa fa-git"></i> git</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/git-square"><i class="fa fa-git-square"></i> git-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/github"><i class="fa fa-github"></i> github</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/github-alt"><i class="fa fa-github-alt"></i> github-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/github-square"><i class="fa fa-github-square"></i> github-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/gratipay"><i class="fa fa-gittip"></i> gittip <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/google"><i class="fa fa-google"></i> google</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/google-plus"><i class="fa fa-google-plus"></i> google-plus</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/google-plus-square"><i class="fa fa-google-plus-square"></i> google-plus-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/google-wallet"><i class="fa fa-google-wallet"></i> google-wallet</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/gratipay"><i class="fa fa-gratipay"></i> gratipay</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/hacker-news"><i class="fa fa-hacker-news"></i> hacker-news</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/html5"><i class="fa fa-html5"></i> html5</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/instagram"><i class="fa fa-instagram"></i> instagram</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ioxhost"><i class="fa fa-ioxhost"></i> ioxhost</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/joomla"><i class="fa fa-joomla"></i> joomla</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/jsfiddle"><i class="fa fa-jsfiddle"></i> jsfiddle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/lastfm"><i class="fa fa-lastfm"></i> lastfm</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/lastfm-square"><i class="fa fa-lastfm-square"></i> lastfm-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/leanpub"><i class="fa fa-leanpub"></i> leanpub</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/linkedin"><i class="fa fa-linkedin"></i> linkedin</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/linkedin-square"><i class="fa fa-linkedin-square"></i> linkedin-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/linux"><i class="fa fa-linux"></i> linux</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/maxcdn"><i class="fa fa-maxcdn"></i> maxcdn</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/meanpath"><i class="fa fa-meanpath"></i> meanpath</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/medium"><i class="fa fa-medium"></i> medium</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/openid"><i class="fa fa-openid"></i> openid</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pagelines"><i class="fa fa-pagelines"></i> pagelines</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/paypal"><i class="fa fa-paypal"></i> paypal</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pied-piper"><i class="fa fa-pied-piper"></i> pied-piper</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pied-piper-alt"><i class="fa fa-pied-piper-alt"></i> pied-piper-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pinterest"><i class="fa fa-pinterest"></i> pinterest</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pinterest-p"><i class="fa fa-pinterest-p"></i> pinterest-p</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/pinterest-square"><i class="fa fa-pinterest-square"></i> pinterest-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/qq"><i class="fa fa-qq"></i> qq</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/rebel"><i class="fa fa-ra"></i> ra <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/rebel"><i class="fa fa-rebel"></i> rebel</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/reddit"><i class="fa fa-reddit"></i> reddit</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/reddit-square"><i class="fa fa-reddit-square"></i> reddit-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/renren"><i class="fa fa-renren"></i> renren</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/sellsy"><i class="fa fa-sellsy"></i> sellsy</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/share-alt"><i class="fa fa-share-alt"></i> share-alt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/share-alt-square"><i class="fa fa-share-alt-square"></i> share-alt-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/shirtsinbulk"><i class="fa fa-shirtsinbulk"></i> shirtsinbulk</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/simplybuilt"><i class="fa fa-simplybuilt"></i> simplybuilt</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/skyatlas"><i class="fa fa-skyatlas"></i> skyatlas</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/skype"><i class="fa fa-skype"></i> skype</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/slack"><i class="fa fa-slack"></i> slack</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/slideshare"><i class="fa fa-slideshare"></i> slideshare</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/soundcloud"><i class="fa fa-soundcloud"></i> soundcloud</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/spotify"><i class="fa fa-spotify"></i> spotify</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/stack-exchange"><i class="fa fa-stack-exchange"></i> stack-exchange</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/stack-overflow"><i class="fa fa-stack-overflow"></i> stack-overflow</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/steam"><i class="fa fa-steam"></i> steam</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/steam-square"><i class="fa fa-steam-square"></i> steam-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/stumbleupon"><i class="fa fa-stumbleupon"></i> stumbleupon</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/stumbleupon-circle"><i class="fa fa-stumbleupon-circle"></i> stumbleupon-circle</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tencent-weibo"><i class="fa fa-tencent-weibo"></i> tencent-weibo</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/trello"><i class="fa fa-trello"></i> trello</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tumblr"><i class="fa fa-tumblr"></i> tumblr</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/tumblr-square"><i class="fa fa-tumblr-square"></i> tumblr-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/twitch"><i class="fa fa-twitch"></i> twitch</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/twitter"><i class="fa fa-twitter"></i> twitter</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/twitter-square"><i class="fa fa-twitter-square"></i> twitter-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/viacoin"><i class="fa fa-viacoin"></i> viacoin</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/vimeo-square"><i class="fa fa-vimeo-square"></i> vimeo-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/vine"><i class="fa fa-vine"></i> vine</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/vk"><i class="fa fa-vk"></i> vk</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/weixin"><i class="fa fa-wechat"></i> wechat <span class="text-muted">(alias)</span></a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/weibo"><i class="fa fa-weibo"></i> weibo</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/weixin"><i class="fa fa-weixin"></i> weixin</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/whatsapp"><i class="fa fa-whatsapp"></i> whatsapp</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/windows"><i class="fa fa-windows"></i> windows</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/wordpress"><i class="fa fa-wordpress"></i> wordpress</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/xing"><i class="fa fa-xing"></i> xing</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/xing-square"><i class="fa fa-xing-square"></i> xing-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/yahoo"><i class="fa fa-yahoo"></i> yahoo</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/yelp"><i class="fa fa-yelp"></i> yelp</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/youtube"><i class="fa fa-youtube"></i> youtube</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/youtube-play"><i class="fa fa-youtube-play"></i> youtube-play</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/youtube-square"><i class="fa fa-youtube-square"></i> youtube-square</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End brand icons -->

                            <!-- Start medical icons -->
                            <div class="panel rounded shadow">
                                <div class="panel-heading">
                                    <div class="pull-left">
                                        <h3 class="panel-title">Medical Icons</h3>
                                    </div><!-- /.pull-left -->
                                    <div class="pull-right">
                                        <button class="btn btn-sm" data-action="collapse" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Collapse"><i class="fa fa-angle-up"></i></button>
                                        <button class="btn btn-sm" data-action="remove" data-container="body" data-toggle="tooltip" data-placement="top" data-title="Remove"><i class="fa fa-times"></i></button>
                                    </div><!-- /.pull-right -->
                                    <div class="clearfix"></div>
                                </div><!-- /.panel-heading -->
                                <div class="panel-body">
                                    <div class="row fontawesome-icon-list">



                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/ambulance"><i class="fa fa-ambulance"></i> ambulance</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/h-square"><i class="fa fa-h-square"></i> h-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/heart"><i class="fa fa-heart"></i> heart</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/heart-o"><i class="fa fa-heart-o"></i> heart-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/heartbeat"><i class="fa fa-heartbeat"></i> heartbeat</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/hospital-o"><i class="fa fa-hospital-o"></i> hospital-o</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/medkit"><i class="fa fa-medkit"></i> medkit</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/plus-square"><i class="fa fa-plus-square"></i> plus-square</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/stethoscope"><i class="fa fa-stethoscope"></i> stethoscope</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/user-md"><i class="fa fa-user-md"></i> user-md</a></div>

                                        <div class="fa-hover col-md-3 col-sm-4"><a href="http://fontawesome.io/icon/wheelchair"><i class="fa fa-wheelchair"></i> wheelchair</a></div>

                                    </div>
                                </div><!-- /.panel-body -->
                            </div><!-- /.panel -->
                            <!--/ End medical icons -->
                            <!-- END FONT AWESOME -->

                        </div>
                    </div><!-- /.row -->

                </div><!-- /.body-content -->
                <!--/ End body content -->

                <!-- Start footer content -->
                <?php require_once './footer.php';?><!-- /.footer-content -->
            </section><!-- /#page-content -->
        </section><!-- /#wrapper -->

        <!-- START @BACK TOP -->
        <div id="back-top" class="animated pulse circle">
            <i class="fa fa-angle-up"></i>
        </div><!-- /#back-top -->
        <!--/ END BACK TOP -->

        <!-- START JAVASCRIPT SECTION (Load javascripts at bottom to reduce load time) -->
        <!-- START @CORE PLUGINS -->
        <script src="./assets/js/jquery.min.js"></script>
        <script src="./assets/bootstrap/dist/js/bootstrap.min.js"></script>
        <script src="./assets/js/handlebars.js"></script>
        <script src="./assets/js/typeahead.bundle.min.js"></script>
        <script src="./assets/js/jquery.nicescroll.min.js"></script>
        <script src="./assets/js/index.js"></script>
        <script src="./assets/js/jquery.easing.1.3.min.js"></script>
        <script src="assets/ionsound/ion.sound.min.js"></script>
        <script src="./assets/js/bootbox.js"></script>
        <!--/ END CORE PLUGINS -->

        <!-- START @PAGE LEVEL SCRIPTS -->
        <script src="./assets/js/apps.js"></script>
        <!--/ END PAGE LEVEL SCRIPTS -->
        <script>
            $('#icone').addClass('active');
        </script>
    </body>
    <!--/ END BODY -->

</html>